USE [EleriumClean]
GO

/****** Object:  Table [dbo].[RewardsProgram]    Script Date: 10/3/2013 8:13:49 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardsProgram](
	[ID] [int] NOT NULL,
	[AddonPercentage] [decimal](3, 2) NOT NULL,
	[BonusPoints] [money] NOT NULL,
	[EcpmBudgetShareModifier] [money] NOT NULL,
	[EcpmImpressionsModifier] [money] NOT NULL,
	[EcpmRevenueModifier] [money] NOT NULL,
	[EstimatedPremiumBudgetDefault] [money] NOT NULL,
	[EstimatedPremiumBudgetTrendModifier] [money] NOT NULL,
	[Fairness] [decimal](3, 2) NOT NULL,
	[LibraryPercentage] [decimal](3, 2) NOT NULL,
	[LibraryThreshold] [int] NOT NULL,
	[PointExchangeRate] [money] NOT NULL,
	[PopularityThreshold] [int] NOT NULL,
 CONSTRAINT [PK_RewardsProgram] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardsProgram]  WITH CHECK ADD  CONSTRAINT [CK_RewardsProgram_AddonPercentage] CHECK  (([AddonPercentage]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardsProgram] CHECK CONSTRAINT [CK_RewardsProgram_AddonPercentage]
GO

ALTER TABLE [dbo].[RewardsProgram]  WITH CHECK ADD  CONSTRAINT [CK_RewardsProgram_Fairness] CHECK  (([Fairness]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardsProgram] CHECK CONSTRAINT [CK_RewardsProgram_Fairness]
GO

ALTER TABLE [dbo].[RewardsProgram]  WITH CHECK ADD  CONSTRAINT [CK_RewardsProgram_LibraryPercentage] CHECK  (([LibraryPercentage]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardsProgram] CHECK CONSTRAINT [CK_RewardsProgram_LibraryPercentage]
GO


